/**
 * @file Vector.cpp
 * @brief xNgNX
 * @author cherub
 * @date 2005.09.16
 */
#include "Vector.h"
#include "Matrix.h"

#include <gsl/gsl_blas.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

/**
 * @fn CVector::CVector(void)
 * @brief ftHgRXgN^
 */
CVector::CVector(void)
{
	m_pvVector = NULL;
}

/**
 * @fn CVector::CVector(const CVector &v)
 * @brief Rs[RXgN^
 * @param v [in] Rs[xNg
 */
CVector::CVector(const CVector &v)
{
	m_pvVector = gsl_vector_alloc(v.m_pvVector->size);
	gsl_vector_memcpy(m_pvVector, v.m_pvVector);
}

/**
 * @fn CVector::CVector(size_t unSize)
 * @brief TCYwRXgN^
 * @param unSize [in] xNg
 */
CVector::CVector(size_t unSize)
{
	if (unSize == 0)
		m_pvVector = NULL;
	else
		m_pvVector = gsl_vector_calloc(unSize);
}

/**
 * @fn CVector::CVector(size_t unSize, double dInit)
 * @brief qTCYwRXgN^
 * @param unSize [in] xNg
 * @param dInit [in] q
 */
CVector::CVector(size_t unSize, double dInit)
{
	m_pvVector = NULL;
	Initialize(unSize, dInit);
}

/**
 * @fn CVector::~CVector(void)
 * @brief fXgN^
 */
CVector::~CVector(void)
{
	Destroy();
}

/**
 * @fn void CVector::Initialize(size_t unSize, double dInit)
 * @brief ֐
 * @param unSize [in] xNg
 * @param dInit [in] q
 * @return Ȃ
 */
void CVector::Initialize(size_t unSize, double dInit)
{
	if (m_pvVector != NULL)
		Destroy();
	if (unSize == 0)
		return;

	m_pvVector = gsl_vector_alloc(unSize);
	gsl_vector_set_all(m_pvVector, dInit);
}

/**
 * @fn void CVector::ZeroClear()
 * @brief xNg̃[NA
 * @return Ȃ
 */
void CVector::ZeroClear()
{
	gsl_vector_set_zero(m_pvVector);
}

/**
 * @fn void CVector::Clear(double dInit)
 * @brief CӒlɂxNgNA
 * @param dInit [in] q
 * @return Ȃ
 */
void CVector::Clear(double dInit)
{
	gsl_vector_set_all(m_pvVector, dInit);
}

/**
 * @fn void CVector::Destroy(void)
 * @brief IuWFNg̔j
 * @return Ȃ
 */
void CVector::Destroy(void)
{
	if (m_pvVector != NULL)
		gsl_vector_free(m_pvVector);
	m_pvVector = NULL;
}

/**
 * @fn CVector& CVector::operator = (const CVector &v)
 * @brief Zq
 * @param v [in] xNg
 * @return gւ̎Q
 */
CVector& CVector::operator = (const CVector &v)
{
	Destroy();

	m_pvVector = gsl_vector_alloc(v.m_pvVector->size);
	gsl_vector_memcpy(m_pvVector, v.m_pvVector);
	return *this;
}

/**
 * @fn size_t CVector::Size(void) const
 * @brief xNg̎擾
 * @return xNg
 */
size_t CVector::Size() const
{
	return m_pvVector->size;
}

/**
 * @fn bool CVector::operator == (const CVector &v) const
 * @brief xNg̈v
 * @retval true v
 * @retval false sv
 */
bool CVector::operator == (const CVector &v) const
{
	for (size_t p = 0;p < m_pvVector->size;p++)
	{
		if (gsl_vector_get(m_pvVector, p) != gsl_vector_get(v.m_pvVector, p))
			return false;
	}
	return true;
}

/**
 * @fn CVector CVector::operator - (void) const
 * @brief s̑Svf̕𔽓]
 * @return Z
 */
/*
CVector CVector::operator - (void) const
{
	CVector tmp(*this);
	gsl_vector_scale(tmp.m_pvVector, -1.0);
	return tmp;
}
*/

/**
 * @fn CVector CVector::operator + (const CVector &m) const
 * @brief ZZq
 * @param v [in] ZΏ
 * @return Z
 */
CVector CVector::operator + (const CVector &v) const
{
	if (m_pvVector->size != v.m_pvVector->size)
		return *this;

	CVector tmp = *this;
	gsl_vector_add(tmp.m_pvVector, v.m_pvVector);
	return tmp;
}

/**
 * @fn CVector CVector::operator - (const CVector &m) const
 * @brief ZZq
 * @param v [in] ZΏ
 * @return Z
 */
CVector CVector::operator - (const CVector &v) const
{
	if (m_pvVector->size != v.m_pvVector->size)
		return *this;

	CVector tmp = *this;
	gsl_vector_sub(tmp.m_pvVector, v.m_pvVector);
	return tmp;
}

/**
 * @fn CVector CVector::operator + (double d) const
 * @brief XJZZq
 * @param d [in] ZΏ
 * @return Z
 */
CVector CVector::operator + (double d) const
{
	CVector tmp = *this;
	gsl_vector_add_constant(tmp.m_pvVector, d);
	return tmp;
}

/**
 * @fn CVector CVector::operator * (double d) const
 * @brief XJZZq
 * @param d [in] ZΏ
 * @return Z
 */
CVector CVector::operator * (double d) const
{
	CVector tmp = *this;
	gsl_vector_scale(tmp.m_pvVector, d);
	return tmp;
}


/**
 * @fn CVector CVector::operator += (const CVector &v)
 * @brief ZZq
 * @param v [in] ZΏ
 * @return Z
 */
CVector& CVector::operator += (const CVector &v)
{
	if (m_pvVector->size != v.m_pvVector->size)
		return *this;

	gsl_vector_add(m_pvVector, v.m_pvVector);
	return *this;
}

/**
 * @fn CVector CVector::operator -= (const CVector &v)
 * @brief ZZq
 * @param v [in] ZΏ
 * @return Z
 */
CVector& CVector::operator -= (const CVector &v)
{
	if (m_pvVector->size != v.m_pvVector->size)
		return *this;

	gsl_vector_sub(m_pvVector, v.m_pvVector);
	return *this;
}

/**
 * @fn CVector CVector::operator += (double d)
 * @brief XJZZq
 * @param d [in] ZΏ
 * @return Z
 */
CVector& CVector::operator += (double d)
{
	gsl_vector_add_constant(m_pvVector, d);
	return *this;
}

/**
 * @fn CVector CVector::operator *= (double d)
 * @brief XJZZq
 * @param d [in] ZΏ
 * @return Z
 */
CVector& CVector::operator *= (double d)
{
	gsl_vector_scale(m_pvVector, d);
	return *this;
}

/**
 * @fn CVector CVector::operator * (const CMatrix &v) const
 * @brief sƂ̏ZZq
 * @param m [in] ZΏ
 * @return Z
 */
CVector CVector::operator * (const CMatrix &m) const
{
	CVector vTmp(m.m_pmMatrix->size2);
	//
	// gsl_blas_dgemv(Op, alpha, matA, vecX, beta, vecY)
	//  vecY = alpha * Op(A) * vecX + beta * vecY;
	//
	gsl_blas_dgemv(CblasTrans, 1.0, m.m_pmMatrix, m_pvVector, 0.0, vTmp.m_pvVector);
	return vTmp;
}

/**
 * @fn double CVector::MinElement(void) const
 * @brief ŏl̎擾
 * @return xNg̍ŏl
 */
double CVector::MinElement(void) const
{
	return gsl_vector_min(m_pvVector);
}

/**
 * @fn double CVector::MaxElement(void) const
 * @brief ől̎擾
 * @return xNg̍ől
 */
double CVector::MaxElement(void) const
{
	return gsl_vector_max(m_pvVector);
}

/**
 * @fn void CVector::MinMaxElement(double &dMin, double &dMax) const
 * @brief ŏlEől̎擾
 * @param dMin [out] xNg̍ŏl
 * @param dMax [out] xNgől
 * @return Ȃ
 */
void CVector::MinMaxElement(double &dMin, double &dMax) const
{
	gsl_vector_minmax(m_pvVector, &dMin, &dMax);
}

/**
 * @fn size_t CVector::MinIndex(void) const
 * @brief ŏlւ̃CfNX̎擾
 * @return xNg̍ŏl̃CfNX
 */
size_t CVector::MinIndex(void) const
{
	return gsl_vector_min_index(m_pvVector);
}

/**
 * @fn size_t CVector::MaxIndex(void) const
 * @brief őlւ̃CfNX̎擾
 * @return xNg̍ől̃CfNX
 */
size_t CVector::MaxIndex(void) const
{
	return gsl_vector_max_index(m_pvVector);
}

/**
 * @fn void CVector::MinMaxIndex(size_t &unMin, size_t &unMax) const
 * @brief ŏlEőlCfNX̎擾
 * @param unMin [out] xNg̍ŏl̃CfNX
 * @param unMax [out] xNg̍ől̃CfNX
 * @return Ȃ
 */
void CVector::MinMaxIndex(size_t &unMin, size_t &unMax) const
{
	size_t minv, maxv;
	gsl_vector_minmax_index(m_pvVector, &minv, &maxv);
	unMin = minv;
	unMax = maxv;
}

/**
 * @fn CVector CVector::ElementsProduct(const CVector &v) const
 * @brief evfꂼ̐ςȂxNgvZ
 * @param v [in] ZΏ
 * @return Z
 */
CVector CVector::ElementsProduct(const CVector &v) const
{
	CVector vTmp = *this;

	gsl_vector_mul(vTmp.m_pvVector, v.m_pvVector);
	return vTmp;
}

/**
 * @fn double CVector::Dot(const CVector &v) const
 * @brief ς̌vZ
 * @param v [in] ZΏ
 * @return Z
 */
double CVector::Dot(const CVector &v) const
{
	double dTmp;

	gsl_blas_ddot(m_pvVector, v.m_pvVector, &dTmp);
	return dTmp;
}

CMatrix CVector::Dot2(const CVector &v) const
{
	int i;
	int j;
	CVector vTmp = *this;
	CMatrix tmp(vTmp.m_pvVector->size, v.m_pvVector->size);
	
	for(i = 0; (unsigned int)i < vTmp.m_pvVector->size; i++)
	{
		for(j = 0; (unsigned int)j < v.m_pvVector->size; j++)
		{
			tmp(i, j) = vTmp[i] * v[j];
		}
	}
	
	return tmp;
}

/**
 * @fn double CVector::Norm(void) const
 * @brief 2̃m̌vZ
 * @return Z
 */
double CVector::Norm(void) const
{
	return gsl_blas_dnrm2(m_pvVector);
}

/**
 * @fn double CVector::SelfSumAbs(void) const
 * @brief Svf̐Βl̘ǎvZ
 * @return Z
 */
double CVector::SelfSumAbs(void) const
{
	return gsl_blas_dasum(m_pvVector);
}
